-- bonus names
BONUSSCANNER_NAMES = {	
--Base Stats
	STR 		= "Strength",
	AGI 		= "Agility",
	STA 		= "Stamina",
	INT 		= "Intellect",
	SPI 		= "Spirit",
	ARMOR 		= "Reinforced Armor",

--Resistances
	ARCANERES 	= "Arcane Resistance",	
	FIRERES 	= "Fire Resistance",
	NATURERES 	= "Nature Resistance",
	FROSTRES 	= "Frost Resistance",
	SHADOWRES 	= "Shadow Resistance",

--Skills
	FISHING 	= "Fishing",
	MINING 		= "Mining",
	HERBALISM 	= "Herbalism",
	SKINNING 	= "Skinning",
	DEFENSE 	= "Defense",
	
--Weapon Skills
	AXE_RATING = "Axe Skill Rating",
  DAGGER_RATING = "Dagger Skill Rating",
  MACE_RATING = "Mace Skill Rating",
	SWORD_RATING = "Sword Skill Rating",
	SWORDH_RATING = "Two-Handed Swords Skill Rating",
	BOW_RATING	= "Bow Skill Rating",
	XBOW_RATING	= "Crossbow Skill Rating",
	GUN_RATING	= "Gun Skill Rating",

--Abilities
	BLOCK		= "Block Rating",
	BLOCKVALUE	= "Block value",
	DODGE 		= "Dodge Rating",
	PARRY 		= "Parry Rating",
	RESILIENCE = "Resilience Rating", 
	DMGWPN = "Increased Weapon Damage", -- Might of Cenarius etc.

--Attack Power
	ATTACKPOWER	= "Attack Power",
	ATTACKPOWERUNDEAD	= "Attack Power against Undead",
-- ATTACKPOWERBEAST	= "Attack Power against Beasts", --Added by jmlsteele
	ATTACKPOWERFERAL	= "Attack Power in feral form",
	RANGEDATTACKPOWER = "Ranged Attack Power",
	
--Critical

	CRIT 		= "Crit. Rating",
	SPELLCRIT 	= "Crit. Spell Rating",
	RANGEDCRIT 	= "Crit. Shots",
	HOLYCRIT 	= "Crit. Holy Spell",

--Hit
	TOHIT 		= "Hit Rating",
	RANGEDHIT	= "Ranged Hit Rating",
	SPELLTOHIT 	= "Spell Hit Rating",
  

--Spell Damage/healing
	DMG 		= "Spell Damage",
	DMGUNDEAD	= "Spell Damage against Undead",
	ARCANEDMG 	= "Arcane Damage",
	FIREDMG 	= "Fire Damage",
	FROSTDMG 	= "Frost Damage",
	HOLYDMG 	= "Holy Damage",
	NATUREDMG 	= "Nature Damage",
	SHADOWDMG 	= "Shadow Damage",
	SPELLPEN 	= "Spell Penetration",
	HEAL 		= "Healing",

--Regen
	HEALTHREG 	= "Life Regeneration",
	MANAREG 	= "Mana Regeneration",

--Health/mana
	HEALTH 		= "Life Points",
	MANA 		= "Mana Points"
};

-- equip and set bonus prefixes:
BONUSSCANNER_PREFIX_EQUIP = "Equip: ";
BONUSSCANNER_PREFIX_SET = "Set: ";
BONUSSCANNER_PREFIX_SOCKET = "Socket Bonus: ";

-- Mana Regen prefixes:
BONUSSCANNER_PREFIX_MANA1 = "Mana";
BONUSSCANNER_PREFIX_MANA2 = "mana";

-- slot extra armor constants
BONUSSCANNER_SLOT_MAINH = "Main Hand";
BONUSSCANNER_SLOT_1H = "One-Hand";
BONUSSCANNER_SLOT_2H = "Two-Hand";
BONUSSCANNER_SLOT_FINGER = "Finger";
BONUSSCANNER_SLOT_TRINKET = "Trinket";

-- passive bonus patterns. checked against lines which start with above prefixes
BONUSSCANNER_PATTERNS_PASSIVE = {
--Base Stats
	{ pattern = "Increases defense rating by (%d+)%.", effect = "DEFENSE" }, --jmlsteele
  { pattern = "Improves your resilience rating by (%d+)%.", effect = "RESILIENCE" }, 

-- Abilities
	{ pattern = "Increases your block rating by (%d+)%.", effect = "BLOCK" },
	{ pattern = "Increases the block value of your shield by (%d+)%.", effect = "BLOCKVALUE" },
	{ pattern = "Increases your dodge rating by (%d+)%.", effect = "DODGE" },
	{ pattern = "Increases your parry rating by (%d+)%.", effect = "PARRY" },

--Crit
	{ pattern = "Increases your critical strike rating by (%d+)%.", effect = "CRIT" },
	{ pattern = "Improves critical strike rating by (%d+)%.", effect = "CRIT" }, 
	{ pattern = "Increases your spell critical strike rating by (%d+)%.", effect = "SPELLCRIT" },
	{ pattern = "Increases spell critical strike rating by (%d+)%.", effect = "SPELLCRIT" },
	{ pattern = "Improves spell critical strike rating by (%d+)%.", effect = "SPELLCRIT" }, -- Benediction etc.

--Damage/Heal
	{ pattern = "Increases damage done by Arcane spells and effects by up to (%d+)%.", effect = "ARCANEDMG" },
	{ pattern = "Increases damage done by Fire spells and effects by up to (%d+)%.", effect = "FIREDMG" },
	{ pattern = "Increases damage done by Frost spells and effects by up to (%d+)%.", effect = "FROSTDMG" },
	{ pattern = "Increases damage done by Holy spells and effects by up to (%d+)%.", effect = "HOLYDMG" },
	{ pattern = "Increases damage done by Nature spells and effects by up to (%d+)%.", effect = "NATUREDMG" },
	{ pattern = "Increases damage done by Shadow spells and effects by up to (%d+)%.", effect = "SHADOWDMG" },
	{ pattern = "Increases healing done by spells and effects by up to (%d+)%.", effect = "HEAL" },
	{ pattern = "Increases damage and healing done by magical spells and effects by up to (%d+)%.", effect = {"HEAL", "DMG"} },
	{ pattern = "Increases damage done to Undead by magical spells and effects by up to (%d+)", effect = "DMGUNDEAD" },
	
	-- Atiesh patterns
	{ pattern = "Increases your spell damage by up to (%d+) and your healing by up to (%d+)%.", effect = {"DMG","HEAL"} },
	{ pattern = "Increases healing done by magical spells and effects of all party members within %d+ yards by up to (%d+)%. ", effect = "HEAL" },
	{ pattern = "Increases damage and healing done by magical spells and effects of all party members within %d+ yards by up to (%d+)%.", effect = {"HEAL", "DMG"} },
	{ pattern = "Restores (%d+) mana per 5 seconds to all party members within %d+ yards%.", effect = "MANAREG" },
	{ pattern = "Increases the spell critical strike rating of all party members within %d+ yards by (%d+)%.", effect = "SPELLCRIT" },
	
	
--Attack power
	{ pattern = "Increases attack power by (%d+)%.", effect = "ATTACKPOWER" },
	{ pattern = "Increases melee and ranged attack power by (%d+)%.", effect = {"ATTACKPOWER","RANGEDATTACKPOWER"} }, -- Andonisus, Reaper of Souls pattern
	{ pattern = "+(%d+) ranged Attack Power%.", effect = "RANGEDATTACKPOWER" },
	{ pattern = "Increases ranged attack power by (%d+)%.", effect = "RANGEDATTACKPOWER" },
  { pattern = "Increases attack power by (%d+) in Cat, Bear, Dire Bear, and Moonkin forms only%.", effect = "ATTACKPOWERFERAL" },
  { pattern = "Increases attack power by (%d+) when fighting Undead%.", effect = "ATTACKPOWERUNDEAD" },
  { pattern = "+(%d+) Attack Power when fighting Undead%.", effect = "ATTACKPOWERUNDEAD" },
  
--Regen
	{ pattern = "Restores (%d+) health per 5 sec%.", effect = "HEALTHREG" }, 
	{ pattern = "Restores (%d+) health every 5 sec%.", effect = "HEALTHREG" },  -- both versions ('per' and 'every') seem to be used
	{ pattern = "Restores (%d+) mana per 5 sec%.", effect = "MANAREG" },
	{ pattern = "Restores (%d+) mana every 5 sec%.", effect = "MANAREG" },
	
--Hit
	{ pattern = "Increases your hit rating by (%d+)%.", effect = "TOHIT" },
	{ pattern = "Improves hit rating by (%d+)%.", effect = "TOHIT" }, 
	{ pattern = "Increases your spell hit rating by (%d+)%.", effect = "SPELLTOHIT" },
	{ pattern = "Improves spell hit rating by (%d+)%.", effect = "SPELLTOHIT" },
	
-- Skill

	{ pattern = "Increases Two-Handed Swords skill rating by (%d+)%.", effect = "SWORDH_RATING" },
	{ pattern = "Increases axe skill rating by (%d+)%.", effect = "AXE_RATING" },
	{ pattern = "Increases dagger skill rating by (%d+)%.", effect = "DAGGER_RATING" },
	{ pattern = "Increases mace skill rating by (%d+)%.", effect = "MACE_RATING" },
	{ pattern = "Increases sword skill rating by (%d+)%.", effect = "SWORD_RATING" },
	{ pattern = "Increases Bow skill rating by (%d+)%.", effect = "BOW_RATING" },
	{ pattern = "Increases Crossbow skill rating by (%d+)%.", effect = "XBOW_RATING" },
	{ pattern = "Increases Gun skill rating by (%d+)%.", effect = "GUN_RATING" },
	

--Penetration
	{ pattern = "Decreases the magical resistances of your spell targets by (%d+).", effect = "SPELLPEN" },
	{ pattern = "Increases your spell penetration by (%d+)%.", effect = "SPELLPEN" }
};

-- generic patterns have the form "+xx bonus" or "bonus +xx" with an optional % sign after the value.

-- first the generic bonus string is looked up in the following table
BONUSSCANNER_PATTERNS_GENERIC_LOOKUP = {
	["All Stats"] 			= {"STR", "AGI", "STA", "INT", "SPI"},
	["Strength"]			= "STR",
	["Agility"]			= "AGI",
	["Stamina"]			= "STA",
	["Intellect"]			= "INT",
	["Spirit"] 			= "SPI",

	["All Resistances"] 	= { "ARCANERES", "FIRERES", "FROSTRES", "NATURERES", "SHADOWRES"},

	["Fishing"]		= "FISHING",
	["Fishing Lure"]	= "FISHING",
	["Increased Fishing"]	= "FISHING",
	["Mining"]		= "MINING",
	["Herbalism"]		= "HERBALISM",
	["Skinning"]		= "SKINNING",
	["Defense"]		= "DEFENSE",
	["Increased Defense"]	= "DEFENSE",

	["Attack Power"] 	= "ATTACKPOWER",
  ["Attack Power when fighting Undead"] 		= "ATTACKPOWERUNDEAD",
	["Attack Power in Cat, Bear, Dire Bear, and Moonkin forms only"] = "ATTACKPOWERFERAL",
	["Weapon Damage"] = "DMGWPN",
	
	-- TBC Patterns Generic/Gems/Sockets
	
	["Spell Crit Rating"] = "SPELLCRIT", 
	["Spell Critical Rating"] = "SPELLCRIT",
	["Spell Critical Strike Rating"] = "SPELLCRIT",
	["Spell Hit Rating"]= "SPELLTOHIT",
	["Spell Power"] = {"HEAL", "DMG"},
	["Critical Strike Rating"] = "CRIT",
	["Crit Rating"] = "CRIT",
	["Spell Penetration"] = "SPELLPEN",
	["Defense Rating"] = "DEFENSE",
	["Mana per 5 Seconds"] = "MANAREG",
	["Mana every 5 Sec"] = "MANAREG",
	["Mana every 5 seconds"] = "MANAREG",
	["Mana restored per 5 seconds"] = "MANAREG",
	["Mana Per 5 sec"] = "MANAREG",
	["mana per 5 sec"] = "MANAREG",
	["Dodge Rating"] 		= "DODGE",
	["Parry Rating"] 		= "PARRY",
	["Resilience Rating"] = "RESILIENCE",
	["Melee Damage"] = "DMGWPN",
	
	-- End TBC Patterns

	["Dodge"] 		= "DODGE",
	["Block"]		= "BLOCK",
	["Block Value"]		= "BLOCKVALUE",
	["Hit"] 		= "TOHIT",
	["Hit Rating"] = "TOHIT",	
	["Spell Hit"]		= "SPELLTOHIT",
	["Blocking"]		= "BLOCK",
	["Ranged Attack Power"]	= "RANGEDATTACKPOWER",
	["ranged Attack Power"]	= "RANGEDATTACKPOWER", -- Experimental for TBC
	["health every 5 sec"]	= "HEALTHREG",
	["Healing"] = "HEAL",
	["Healing Spells"] 	= "HEAL",
	["Increases Healing"] 	= "HEAL",
	["Healing and Spell Damage"]	= {"HEAL", "DMG"},
	["Damage and Healing Spells"]	= {"HEAL", "DMG"}, -- Possibly Redundant
	["Spell Damage and Healing"]	= {"HEAL", "DMG"}, -- Possibly Redundant
	["mana every 5 sec"] 	= "MANAREG",
	["Mana Regen"]		= "MANAREG",
	["Spell Damage"]	= {"HEAL", "DMG"},
	["Critical"]		= "CRIT",
	["Critical Hit"]	= "CRIT",
	["Damage"]		= {"DMG", "HEAL"},
	["Health"]		= "HEALTH",
	["HP"]			= "HEALTH",
	["Mana"]		= "MANA",
	["Armor"]		= "ARMOR",
	["Reinforced"]	= "ARMOR",
	["Resilience"]			= "RESILIENCE"
};	

-- next we try to match against one pattern of stage 1 and one pattern of stage 2 and concatenate the effect strings
BONUSSCANNER_PATTERNS_GENERIC_STAGE1 = {
	{ pattern = "Arcane", 	effect = "ARCANE" },	
	{ pattern = "Fire", 	effect = "FIRE" },	
	{ pattern = "Frost", 	effect = "FROST" },	
	{ pattern = "Holy", 	effect = "HOLY" },	
	{ pattern = "Shadow",	effect = "SHADOW" },	
	{ pattern = "Nature", 	effect = "NATURE" }
}; 	

BONUSSCANNER_PATTERNS_GENERIC_STAGE2 = {
	{ pattern = "Resist", 	effect = "RES" },	
	{ pattern = "Damage", 	effect = "DMG" },
	{ pattern = "Effects", 	effect = "DMG" }
}; 	

-- finally if we got no match, we match against some special enchantment patterns.
BONUSSCANNER_PATTERNS_OTHER = {
	{ pattern = "Mana Regen (%d+) per 5 sec%.", effect = "MANAREG" },
	{ pattern = "(%d+) Mana per 5 Sec%.", effect = "MANAREG" },
	{ pattern = "Reinforced %(%+(%d+) Armor%)", effect = "ARMOR" },
	
	{ pattern = "Minor Wizard Oil", effect = {"DMG", "HEAL"}, value = 8 },
	{ pattern = "Lesser Wizard Oil", effect = {"DMG", "HEAL"}, value = 16 },
	{ pattern = "Wizard Oil", effect = {"DMG", "HEAL"}, value = 24 },
	{ pattern = "Brilliant Wizard Oil", effect = {"DMG", "HEAL", "SPELLCRIT"}, value = {36, 36, 14} },

	{ pattern = "Minor Mana Oil", effect = "MANAREG", value = 4 },
	{ pattern = "Lesser Mana Oil", effect = "MANAREG", value = 8 },
	{ pattern = "Brilliant Mana Oil", effect = { "MANAREG", "HEAL"}, value = {12, 25} },
	
	{ pattern = "Eternium Line", effect = "FISHING", value = 5 }, 
	
	--{ pattern = "%+31 Healing and 5 mana per 5 sec%.", effect = { "MANAREG", "HEAL"}, value = {5, 31} }, -- Sapphiron Healing Enchant
	--{ pattern = "%+35 Healing and 7 Mana Per 5 sec%.", effect = { "MANAREG", "HEAL"}, value = {7, 35} }, -- Honor Hold Enchant
	--{ pattern = "Healing %+11 and 2 mana per 5 sec%.", effect = { "MANAREG", "HEAL"}, value = {2, 11} },

};
