
-- holds info until know if a spell succeded
SW_PendingCast = {
	spellName = nil,
	spellCost = 0,
};

local SW_ManaRegEx = string.gsub(MANA_COST, "%%d","(%%d+)");

function SW_GetManaCost(str)
	if str == nil then return nil; end
	local _,_, spellCost = string.find(str, SW_ManaRegEx);
	if spellCost == nil then return nil; end
	return tonumber(spellCost);
end

function SW_AcceptPendingCast()
	if not SW_PendingCast.spellName then
		return;
	end
	--[[
	SW_printStr("--AddMC--");
	SW_printStr(SW_PendingCast.spellName);
	SW_printStr(SW_PendingCast.spellCost);
	--]]
	SW_DataCollection:addCT(SW_PendingCast.spellName, SW_PendingCast.spellCost);
	
	-- setting the spell name = nil on periodic spells like arcane missles is important
	-- they add multiple succedeed msgs
	SW_PendingCast.spellName = nil;
end

