﻿
local me = { name = "vamp"}
local mod = thismod
mod[me.name] = me

--[[
VampiricTouch.lua

Handles the priest spell Vampiric Touch.

This doesn't really deserve its own module, but the implementation in Combat.lua and CombatParser.lua is bad enough that it doesn't fit well there. Before 19.18 there was no mechanism to gain threat from mana from your party, it being assumed that all such sources no longer gave threat to you (e.g. Blessing of Wisdom), or that the threat was directed to the beneficiary.


----------------------------------------------------
		World of Warcraft Implementation
----------------------------------------------------

Vampiric Touch is a debuff applied to a mob. While it is active, for each point of shadow damage you deal to that mob, everyone in your party gains 20% as much mana.

The power gain format string for party members' mana gain is POWERGAINSELFOTHER = "%s gains %d %s from %s." . The event is either CHAT_MSG_SPELL_PARTY_BUFF or CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS, probably the former but i'm not 100% sure, and it won't hurt to check both.


----------------------------------------------------
			KTM Implementation
----------------------------------------------------

One problem is that POWERGAINSELFOTHER is identical in format to POWERGAINOTHER. The latter is used when the other player gains mana from his own ability, e.g. a warlock life tapping.

Due to this an other complications, we default to deny; all POWERGAINSELFOTHER captures are assumed to be 0 threat unless we specifically identify the spell. Currently we are only allowing Vampiric Touch, this might change later.

Once we detect Vampiric Touch mana gains, we should check for "overheal" equivalent, which means we have to find the unit ID of the party member.

It hasn't been tested whether threat modifiers such as talents or Blessing of Salvation affect the threat from mana gain, but it is believed not, since personal power gains aren't affected by these.


----------------------------------------------------
			Interaction with other modules
----------------------------------------------------

We require this localisation key (english example)
	"spell" - "vampirictouch"	= "Vampiric Touch"

We call the method <mod.combat.lognormalevent> to update our threat.


--------------------------------------------------------
				Debugging
--------------------------------------------------------

To enable all debugging of this module, uncomment these lines:

	me.mytraces = 
	{
		default = "info",
	}

The following trace prints exist - see Trace.lua for enabling individual traces.

"badtarget"		-	can't find unitid to match player name
"threat"			-	threat added from successfully processed event
]]


me.spellid = "vampirictouch"
me.spellname = ""	-- see <me.onload> below

--[[
------------------------------------------------------------------------
			Services from Loader.lua
------------------------------------------------------------------------
]]

me.onload = function()
	
	me.spellname = mod.string.tryget("spell", me.spellid)
	
end

--[[
------------------------------------------------------------------------
			Services from Regex.lua
------------------------------------------------------------------------
]]

me.myparsers = 
{
	{"powergift", "POWERGAINSELFOTHER", "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS"}, -- "%s gains %d %s from %s."
	{"powergift", "POWERGAINSELFOTHER", "CHAT_MSG_SPELL_PARTY_BUFF"}, -- "%s gains %d %s from %s."
}

me.onparse = function(identifier, playername, value, powertype, source)
	
	-- check for spell match
	if source ~= me.spellname then
		return
	end
	
	-- identify unit id of player
	local unitid 
	
	for x = 1, 4 do
		if UnitName("party" .. x) == playername then
			unitid = "party" .. x
			break
		end
	end
	
	-- couldn't find player: debug then exit
	if unitid == nil then
		
		if mod.trace.check("info", me, "badtarget") then
			mod.trace.printf("Couldn't find the party unitid to match '%s'.", playername)
		end
		
		return
	end
	
	-- check for overheal equivalent
	local manavoid = math.max(0, UnitManaMax(unitid) - UnitMana(unitid))
	value = math.min(manavoid, value)
	
	-- calculate threat
	local threat = value * 0.5
	
	-- debug threat
	if mod.trace.check("info", me, "threat") then
		mod.trace.printf("Adding %d threat from %d modified power gain by %s.", threat, value, playername)
	end
	
	-- submit
	mod.combat.lognormalevent(me.spellname, 1, value, threat)
	
end