﻿
local me = { name = "soulshatter"}
local mod = thismod
mod[me.name] = me

--[[
KTM_Soulshatter.lua

Handles the warlock spell Soulshatter.

----------------------------------------------------
		World of Warcraft Implementation
----------------------------------------------------

Soulshatter is an instant cast spell that reduces your threat by 50% on all enemies in 50 yards. It can be resisted. It is not known if it can be partially resisted - resisted by one mob but not another.

When the spell is cast, you get a CHAT_MSG_SPELL_SELF_DAMAGE event with format SPELLTERSE_SELF; in english "You cast Soulshatter." 

After that, for each mob that is effected you will receive another CHAT_MSG_SPELL_SELF_DAMAGE, with either SPELLRESISTSELFOTHER for a resist ("Your Soulshatter was resisted by %s.") or SIMPLECASTSELFOTHER for a success: "You cast Soulshatter on %s."

----------------------------------------------------
			KTM Implementation
----------------------------------------------------

If the Master target is active, we want to wait for all the events to come through to see if he was affected or resisted. We also want to prevent multiple soul shatters on two mobs with the same source.

We probably don't need to worry about me.caststart and me.isactive and related code, but i'll put in in anyway.

----------------------------------------------------
			Interaction with other modules
----------------------------------------------------

We require this localisation key (english example)
	"spell" - "soulshatter"	= "Soulshatter"

We call the method <mod.combat.lognormalevent> to update our threat.
We also use <mod.table.getraidthreat> and <mod.target.mastertarget>.

--------------------------------------------------------
				Debugging
--------------------------------------------------------

To enable all debugging of this module, uncomment these lines:

	me.mytraces = 
	{
		default = "info",
	}

The following trace prints exist - see Trace.lua for enabling individual traces.

"cooldown"		-	event after one has already fired recently
"start"         -   initial cast event
"mtmismatch"    -   cast on target not the MT
"resist"        -   resist
"success"       -   success
]]

--[[
klhtm.soulshatter.test()

Correctness checking. Should only get -50% threat.
]]
me.test = function()

    event = "CHAT_MSG_SPELL_SELF_DAMAGE"
    arg1 = "You cast Soulshatter."
    mod.event.frameonevent()

    event = "CHAT_MSG_SPELL_SELF_DAMAGE"
    arg1 = "You cast Soulshatter on bob."
    mod.event.frameonevent()
    
    event = "CHAT_MSG_SPELL_SELF_DAMAGE"
    arg1 = "You cast Soulshatter on bob."
    mod.event.frameonevent()

end

--[[
------------------------------------------------------------------------
			    Variables
------------------------------------------------------------------------
]]

me.spellid = "soulshatter"
me.spellname = ""	-- see <me.onload> below

me.isactive = false
me.caststart = 0    -- GetTime()
me.cooldown = 0     -- GetTime() + 5 from effect

--[[
------------------------------------------------------------------------
			Services from Loader.lua
------------------------------------------------------------------------
]]

me.onload = function()
	
	me.spellname = mod.string.tryget("spell", me.spellid)
	
end

--[[
------------------------------------------------------------------------
			Services from Events.lua
------------------------------------------------------------------------
]]

me.myonupdates = 
{
    updatetimeout = 0.5
}

me.updatetimeout = function()

    if GetTime() > me.caststart + 1 then
        me.isactive = false
    end

end

--[[
------------------------------------------------------------------------
			Services from Regex.lua
------------------------------------------------------------------------
]]

me.myparsers = 
{
	{"resist", "SPELLRESISTSELFOTHER", "CHAT_MSG_SPELL_SELF_DAMAGE"},   -- "Your %s was resisted by %s."
	{"cast", "SPELLTERSE_SELF", "CHAT_MSG_SPELL_SELF_DAMAGE"},          -- "You cast %s."
    {"casttarget", "SIMPLECASTSELFOTHER", "CHAT_MSG_SPELL_SELF_DAMAGE"},-- "You cast %s on %s."
    
    -- we need to put this in or SPELLCASTGOSELFTARGETTED could cut us off
    {"casttarget", "SPELLCASTGOSELFTARGETTED", "CHAT_MSG_SPELL_SELF_DAMAGE"},-- "You cast %s on %s."
}

me.onparse = function(action, spell, target)
	    
    -- check for spell match
	if spell ~= me.spellname then
		return
	end
    
    if mod.trace.check("info", me, "cooldown") then
        mod.trace.printf("Action = %s.", action)
    end
    
    -- ignore if soulshatter is cooling down
    if GetTime() < me.cooldown then
        
        if mod.trace.check("info", me, "cooldown") then
            mod.trace.printf("Ignoring %s action due to cooldown.", action)
        end
        
        return
    end
    
    -- if soulshatter is inactive, start the sequence
    if me.isactive == false then
        me.isactive = true
        me.caststart = GetTime()
        
        if mod.trace.check("info", me, "start") then
            mod.trace.printf("Soulshatter sequence started by the %s action.", action)
        end
    end
    
    -- no more actions for sequence opener
    if action == "cast" then
        return
    end
    
    -- if there is a master target defined, ignore targets that don't match it
    if mod.target.mastertarget and target ~= mod.target.mastertarget then
    
        if mod.trace.check("info", me, "mtmismatch") then
            mod.trace.printf("Ignoring soulshatter action %s because the target %s does not match the master target %s.", action, target, mod.target.mastertarget)
        end
    end
    
    -- take the result and put us on cooldown
    if action == "resist" then
        
        -- debug
        if mod.trace.check("info", me, "resist") then
            mod.trace.printf("Soulshatter resisted by %s", target)
        end
        
        return
        
    else
        -- cast
        local threat = mod.table.getraidthreat() * -0.5
        mod.combat.lognormalevent(me.spellname, 1, 0, threat)
        
        -- debug
        if mod.trace.check("info", me, "success") then
            mod.trace.printf("Soulshatter successfully cast on %s", target)
        end
    end
    
    me.cooldown = GetTime() + 5
end