﻿
local me = { name = "lacerate"}
local mod = thismod
mod[me.name] = me

--[[
Abilities\Lacerate.lua

This is a handler for the Druid Bear form ability Lacerate.

Lacerate applies a bleed (dot) on the target. There is a fixed amount of threat on application, and damage over time at normal threat.

We can't detect a cast from the combat log if there are 5 stacks already. Therefore we register UNIT_SPELLCAST_SUCCEEDED and check for a Lacerate Cast. 

The cast will fail if we get a miss, or if the mob is immune. We believe that all such messages will come from the CHAT_MSG_SPELL_SELF_DAMAGE event.

Some code is placed outside this module necessarily:

--> Localisation files for the values of "spell" - "lacerate"
--> Data.lua in <me.spells> for the threat value of Lacerate 

Note in Data.lua that we give Lacerate a <.multiplier> of 1.0. This will override the <.threat> property in Combat.lua, so the threat won't get added to each tick of the dot.

]]

me.myevents = { "UNIT_SPELLCAST_SUCCEEDED", "CHAT_MSG_SPELL_SELF_DAMAGE" }

me.onevent = function()

	if event == "UNIT_SPELLCAST_SUCCEEDED" then
		if string.find(arg2, mod.string.get("spell", "lacerate")) then
			me.castlacerate(1)
		end
	
	elseif event == "CHAT_MSG_SPELL_SELF_DAMAGE" then
		if string.find(arg1, mod.string.get("spell", "lacerate")) then
			me.castlacerate(-1)
		end
	end
end

--[[
me.castlacerate(count)

This casts or retracts a cast of lacerate. <count> is the number of hits, so set it to 1 to cast, or -1 to retract.
]]
me.castlacerate = function(count)
	
	-- 1) check for master target
	if mod.target.targetismaster(UnitName("target")) == nil then
		return
	end
	
	-- 2) determine total threat
	local threat = count * mod.my.ability("lacerate", "threat") * mod.my.globalthreat.value 

	-- 3) record
	mod.combat.lognormalevent(mod.string.get("spell", "lacerate"), count, 0, threat)
	
end