local aceOO = AceLibrary("AceOO-2.0")
local metro = AceLibrary("Metrognome-2.0")

Druidcom_Druid = aceOO.Class()
Druidcom_Druid.TARGETEXPIRETIME = 20
Druidcom_Druid.FLASHCOLOR = {	["RED"]		= {r=0.8, g=0.1, b=0.1, a=0.7},
								["YELLOW"]	= {r=0.7, g=0.7, b=0.0, a=0.7},
								["GREEN"]	= {r=0.1, g=0.8, b=0.1, a=0.7}}
Druidcom_Druid.ABILITIES = {["Innervate"] = {	UnitIsSuitableTarget = function(unit)
																		return (UnitMana(unit.unitid)/UnitManaMax(unit.unitid) <= Druidcom.db.profile.Mana_Threshold) and not UnitIsDeadOrGhost(unit.unitid)
																	end,
												cooldown = 6*60},

							["Rebirth"] = {		UnitIsSuitableTarget = function(unit)
																		return UnitIsDeadOrGhost(unit.unitid)
																	end,
												cooldown = 30*60}
					}

Druidcom_Druid.prototype.Targets = {}
Druidcom_Druid.prototype.Cooldowns = {}


function Druidcom_Druid.prototype:init(name, subgroup, unitid)
	Druidcom_Druid.super.prototype.init(self)
	self.Name = name
	self.Subgroup = subgroup
	self.unitid = unitid

	for ability in pairs(Druidcom_Druid.ABILITIES) do
		if( not metro:Status(name..ability.."MinuteCounter")) then
			metro:Register(name..ability.."MinuteCounter", self.UpdateCooldown, 60, self, -1, ability, "minute")
		end
		if( not metro:Status(name..ability.."SecondCounter")) then
			metro:Register(name..ability.."SecondCounter", self.UpdateCooldown, 1, self, -1, ability, "second")
		end
		if( not metro:Status(name..ability.."TargetExpireCounter")) then
			metro:Register(name..ability.."TargetExpireCounter", self.TargetExpired, Druidcom_Druid.TARGETEXPIRETIME, self, ability)
		end
	end
end

function Druidcom_Druid.prototype:destroy()
	for _, ability in ipairs(Druidcom_Druid.ABILITIES) do
		metro:Unregister(	self.Name..ability.."MinuteCounter",
							self.Name..ability.."SecondCounter",
							self.Name..ability.."TargetExpireCounter")
	end
end

function Druidcom_Druid.prototype:toString()
	return self.Subgroup.."-"..self.Name
end

-- UpdateCooldown(cd, ability, lastcall)
-- cd - number
-- ability - string, which cooldown to update
-- lastcall - either "minute" or "second"
-- returns nil
-- This method updates the cooldown specified by ability. If the argument "cd" is specified,
-- the cooldown will be set to it. Otherwise, the current cooldown will be
-- counted down according to the lastcall parameter. If lastcall is "minute", the
-- cooldown is decreased by 60 seconds. If lastcall is "second", the cooldown is
-- decreased by 1 second. If necessary, the method starts a new timer that calls
-- the method again. The length of the timer is as long as possible to reduce CPU
-- load and memory usage.
function Druidcom_Druid.prototype:UpdateCooldown(cd, ability, lastcall)
	Druidcom.Debug(Druidcom, "---- UpdateCooldown ----")
	Druidcom.Debug(Druidcom, "cd=",cd)
	Druidcom.Debug(Druidcom, "floor(cd)=",floor(cd))
	Druidcom.Debug(Druidcom, "ability=",ability)
	Druidcom.Debug(Druidcom, "lastcall=",lastcall)
	Druidcom.Debug(Druidcom, "SavedCD=",self.Cooldowns[ability])
	Druidcom.Debug(Druidcom, "---- ----- ----")
	if(cd ~=-1) then
		self.Cooldowns[ability] = floor(cd)
	end
	if(not self.Cooldowns[ability]) then return end
	if(cd==-1 and self.Cooldowns[ability] > 0) then
		if(lastcall == "minute") then
			self.Cooldowns[ability] = floor(self.Cooldowns[ability] - 60)
		elseif(lastcall == "second") then
			self.Cooldowns[ability] = floor(self.Cooldowns[ability] - 1)
		end
	end
	-- start the next counter
	local minuteCounter = self.Name..ability.."MinuteCounter"
	local secondCounter = self.Name..ability.."SecondCounter"
	local _, _, mRunning, _, _ = metro:Status(minuteCounter)
	local _, _, sRunning, _, _ = metro:Status(secondCounter)
	if(self.Cooldowns[ability] > 60 and mod(self.Cooldowns[ability], 60) == 0) then
		Druidcom.Debug(Druidcom, "Minutencounter")
		if(sRunning) then metro:Stop(secondCounter) end
		if(not mRunning) then
			local numCalls = self.Cooldowns[ability]/60 - 1
			Druidcom.Debug(Druidcom, "wird gestartet, numCalls = ", numCalls)
			metro:Start(minuteCounter, numCalls)
		end
	elseif(self.Cooldowns[ability] > 0) then
		Druidcom.Debug(Druidcom, "Sekundencounter")
		if(mRunning) then metro:Stop(minuteCounter) end
		if(not sRunning) then
			Druidcom.Debug(Druidcom, "wird gestartet")
			success = metro:Start(secondCounter, self.Cooldowns[ability])
		end
	else
		if(mRunning) then metro:Stop(mCounter) end
		if(sRunning) then metro:Stop(secondCounter) end
	end
	self:UpdateButton(ability)
	Druidcom.Debug(Druidcom, "SavedCD=",self.Cooldowns[ability])
	self:UpdateNameString()
	Druidcom.Debug(Druidcom, "SavedCD=",self.Cooldowns[ability])
end

function Druidcom_Druid.prototype:UpdateButton(ability)
	if(not self.FrameNumber) then return end
	if(self.Cooldowns[ability]) then
		if(self.Cooldowns[ability] > 0) then
			getglobal("Druidcom"..self.FrameNumber..ability.."ButtonNormalTexture"):SetVertexColor(0.3, 0.3, 0.3)
			local label = getglobal("Druidcom"..self.FrameNumber..ability.."Button_Label")
			if(self.Cooldowns[ability] <= 60) then
				local v = self.Cooldowns[ability] / 60
				label:SetTextColor(1.0, v, v)
				label:SetText(string.format("%d", self.Cooldowns[ability]))
			else
				label:SetTextColor(1.0, 1.0, 1.0)
				label:SetText(string.format("%d", math.ceil(self.Cooldowns[ability]/60)))
			end
		else
			getglobal("Druidcom"..self.FrameNumber..ability.."ButtonNormalTexture"):SetVertexColor(1.0, 1.0, 1.0)
			getglobal("Druidcom"..self.FrameNumber..ability.."Button_Label"):SetText("")
		end
	else
		getglobal("Druidcom"..self.FrameNumber..ability.."ButtonNormalTexture"):SetVertexColor(0.3, 0.3, 0.3)
		getglobal("Druidcom"..self.FrameNumber..ability.."Button_Label"):SetText("?")
	end
end


function Druidcom_Druid.prototype:UpdateNameString()
	if(not self.FrameNumber) then return end
	local hasSentCooldowns
	for ability in pairs(self.Cooldowns) do
		hasSentCooldowns = true
	end
	local fontstring = getglobal("Druidcom"..self.FrameNumber.."Name")
	fontstring:SetText(self:toString())
	if(not UnitIsConnected(self.unitid)) then
		fontstring:SetTextColor(0.5, 0.5, 0.5) --gray if offline
	elseif(not hasSentCooldowns) then
		fontstring:SetTextColor(0, 0, 1.0) -- blue if no Druidcom found
	elseif(UnitIsDeadOrGhost(self.unitid)) then
		fontstring:SetTextColor(1.0, 0, 0) -- red if dead
	elseif(not UnitIsVisible(self.unitid)) then
		fontstring:SetTextColor(1.0, 1.0, 0) -- yellow if out of range
	else
		fontstring:SetTextColor(0, 1.0, 0) -- green if everything is ok
	end
end

function Druidcom_Druid.prototype:UpdateFrame()
	self:UpdateNameString()
	for _, ability in ipairs(Druidcom_Druid.ABILITIES) do
		self:UpdateButton(ability)
	end
end

function Druidcom_Druid.prototype:ActionReceived(ability, targetname, isRequest)
	if(targetname and isRequest) then
		-- new target assigned
		self.Targets[ability] = targetname
		metro:Start(self.Name..ability.."TargetExpireCounter", 1)
	elseif(targetname) then
		-- action taken on...
		if(targetname == self.Targets[ability]) then
			--... assigned target, good boy!
			self:ButtonFlash(ability, "GREEN")
		else
			--... other target
			self:ButtonFlash(ability, "YELLOW")
		end
		self:UpdateCooldown(Druidcom_Druid.ABILITIES[ability].cooldown, ability)
		metro:Stop(self.Name..ability.."TargetExpireCounter")
	else
		-- no action taken (request declined or ignored)
		self:ButtonFlash(ability, "RED")
		metro:Stop(self.Name..ability.."TargetExpireCounter")
	end
end

function Druidcom_Druid.prototype:TargetExpired(ability)
	self.Targets[ability] = nil
	self:ButtonFlash(ability, "RED")
end

function Druidcom_Druid.prototype:ButtonFlash(ability, color)
	if(not self.FrameNumber) then return end
	local r,g,b,a
	r= Druidcom_Druid.FLASHCOLOR[color].r
	g= Druidcom_Druid.FLASHCOLOR[color].g
	b= Druidcom_Druid.FLASHCOLOR[color].b
	a= Druidcom_Druid.FLASHCOLOR[color].a
	local flashframe = getglobal("Druidcom"..self.FrameNumber..ability.."ButtonFlashOverlayTexture")
	flashframe:SetTexture(r,g,b,a)
	flashframe = getglobal("Druidcom"..self.FrameNumber..ability.."ButtonFlashOverlay")
	if(UIFrameIsFading(flashframe)) then
		UIFrameFlashRemoveFrame(flashframe)
		flashframe:SetAlpha(0)
	end
	UIFrameFlash(flashframe, 1, 1, 6, false, 0, 0)
end

function Druidcom_Druid.prototype:SetFrameNumber(frameNumber)
	self.FrameNumber = frameNumber
	self:UpdateNameString()
	for ability in pairs(Druidcom_Druid.ABILITIES) do
		self:UpdateButton(ability)
	end
end
