
--------------------  Basic Setup  ------------------------------------------

	Druidcom = AceLibrary("AceAddon-2.0"):new(	"AceConsole-2.0",
												"AceDB-2.0",
												"AceEvent-2.0",
												"AceDebug-2.0",
												"AceComm-2.0",
												"AceHook-2.0",
												"Metrognome-2.0")
	Druidcom:RegisterDB("DruidcomDB")
	local defaultsTable={
				hidden = false,
				Classes = {	["Innervate"] = {
										["PRIEST"] = true,
										["DRUID"] = true,
										["MAGE"] = true,
										["PALADIN"] = true,
										["SHAMAN"] = true,
										["HUNTER"] = true,
										["WARLOCK"] = true},
							["Rebirth"] = {
									["WARRIOR"] = true,
									["DRUID"] = true,
									["PRIEST"] = true,
									["MAGE"] = true,
									["PALADIN"] = true,
									["SHAMAN"] = true,
									["HUNTER"] = true,
									["ROGUE"] = true,
									["WARLOCK"] = true}},
				Mana_Threshold = 0.2,
				xPos = 300,
				yPos= 300,
				minimized = true,
				refreshTime = 0
	}
	Druidcom:RegisterDefaults("profile", defaultsTable)

	Druidcom:SetCommPrefix("Druidcom")
----------------------  Locals  -----------------------------------------------
	local L 		= AceLibrary("AceLocale-2.1"):GetInstance("Druidcom", true)
	local rosterlib	= AceLibrary("RosterLib-2.0")
	local dewdrop 	= AceLibrary("Dewdrop-2.0")
	local crayon	= AceLibrary("Crayon-2.0")
	local titleFrame
	local mainFrame
	local druids = {}
	local PeopleInCharge = {}
	local SpellIndex = {}
	-- This will contain the spell that is waiting to be targeted
	local Druidcom_Spell
	-- This will contain the spell that has been cast and targeted and is awaiting a SPELLCAST_STOP
	local Druidcom_EndCast
	-- This contains the target of the current spell being casting
	local Druidcom_Target
	local enabled = false
	local COLOR = {
				["DRUID"] 	= {r = 1.00, 	g=0.49, 	b=0.04},
				["HUNTER"] 	= {r = 0.67, 	g=0.83, 	b=0.45},
				["MAGE"] 	= {r = 0.41, 	g=0.80, 	b=0.94},
				["PALADIN"]	= {r = 0.96, 	g=0.55, 	b=0.73},
				["PRIEST"] 	= {r = 1.00, 	g=1.00, 	b=1.00},
				["ROGUE"] 	= {r = 1.00, 	g=0.96, 	b=0.41},
				["SHAMAN"] 	= {r = 0.96, 	g=0.55, 	b=0.73},
				["WARLOCK"] = {r = 0.58, 	g=0.51, 	b=0.79},
				["WARRIOR"] = {r = 0.78, 	g=0.61, 	b=0.43},
				["GREENHEX"] = "00FF00",
				["REDHEX"] = "FF0000",
				["YELLOWHEX"] = "FFFF00",
				["BLUEHEX"] = "0000FF",
				["GRAYHEX"] = "888888",
		}
	local OptionsTable={
		type="group",
		name="Druidcom",
		args= {
			Innervate_Classes ={
				type="group",
				name=L["Innervate Classes"],
				desc=L["Which classes should be shown in the innervate menu?"],
				args = {
					druid = {
						type="toggle",
						name=L["DRUID"],
						desc=L["Show Druids"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["DRUID"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["DRUID"] = value end
					},
					priest = {
						type="toggle",
						name=L["PRIEST"],
						desc=L["Show Priests"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["PRIEST"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["PRIEST"] = value end
					},
					mage = {
						type="toggle",
						name=L["MAGE"],
						desc=L["Show Mages"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["MAGE"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["MAGE"] = value end
					},
					paladin = {
						type="toggle",
						name=L["PALADIN"],
						desc=L["Show Paladins"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["PALADIN"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["PALADIN"] = value end
					},
					shaman = {
						type="toggle",
						name=L["SHAMAN"],
						desc=L["Show Shamans"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["SHAMAN"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["SHAMAN"] = value end
					},
					hunter = {
						type="toggle",
						name=L["HUNTER"],
						desc=L["Show Hunters"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["HUNTER"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["HUNTER"] = value end
					},
					warlock = {
						type="toggle",
						name=L["WARLOCK"],
						desc=L["Show Warlocks"],
						get = function() return Druidcom.db.profile.Classes["Innervate"]["WARLOCK"] end,
						set = function(value) Druidcom.db.profile.Classes["Innervate"]["WARLOCK"] = value end
					}
				},
				guiHidden = false,
				cmdHidden = true
			},

			Rebirth_Classes ={
				type="group",
				name=L["Rebirth Classes"],
				desc=L["Which classes should be shown in the rebirth menu?"],
				args = {
					warrior = {
						type="toggle",
						name=L["WARRIOR"],
						desc=L["Show Warriors"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["WARRIOR"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["WARRIOR"] = value end
					},
					druid = {
						type="toggle",
						name=L["DRUID"],
						desc=L["Show Druids"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["DRUID"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["DRUID"] = value end
					},
					priest = {
						type="toggle",
						name=L["PRIEST"],
						desc=L["Show Priests"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["PRIEST"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["PRIEST"] = value end
					},
					mage = {
						type="toggle",
						name=L["MAGE"],
						desc=L["Show Mages"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["MAGE"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["MAGE"] = value end
					},
					paladin = {
						type="toggle",
						name=L["PALADIN"],
						desc=L["Show Paladins"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["PALADIN"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["PALADIN"] = value end
					},
					shaman = {
						type="toggle",
						name=L["SHAMAN"],
						desc=L["Show Shamans"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["SHAMAN"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["SHAMAN"] = value end
					},
					rogue = {
						type="toggle",
						name=L["ROGUE"],
						desc=L["Show Rogues"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["ROGUE"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["ROGUE"] = value end
					},
					hunter = {
						type="toggle",
						name=L["HUNTER"],
						desc=L["Show Hunters"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["HUNTER"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["HUNTER"] = value end
					},
					warlock = {
						type="toggle",
						name=L["WARLOCK"],
						desc=L["Show Warlocks"],
						get = function() return Druidcom.db.profile.Classes["Rebirth"]["WARLOCK"] end,
						set = function(value) Druidcom.db.profile.Classes["Rebirth"]["WARLOCK"] = value end
					}
				},
				guiHidden = false,
				cmdHidden = true
			},

			toggle ={
				type="toggle",
				name=L["toggle"],
				desc=L["Toggle the Druidcom window"],

				get = function()
					return Druidcom.db.profile.hidden
				end,
				
				set = "ToggleHidden",
				map = { [false] = L["show"], [true] = L["hide"] },
				guiHidden = true,
				cmdHidden = false
			},

			reset ={
				type="execute",
				name=L["reset"],
				desc=L["Reset Druidcom's Position"],

				func = function()
					Druidcom.db.profile.xPos = 300
					Druidcom.db.profile.yPos = 300
					titleFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT",-- and attach it to the screen
					                                  300,-- with the saved coordinates
					                                  300)

				end
			},

-- 			debugme ={
-- 				type="execute",
-- 				name="Debug Me",
-- 				desc="Debugging",
-- 
-- 				func = "DebugMe"
-- 			},

			Mana_Threshold = {
				type="range",
				name=L["Mana Threshold"],
				desc=L["Raid Members with mana above this threshold will not be shown in the innervate menu"],
				step=0.01,
				isPercent = true,

				get = function()
					return Druidcom.db.profile.Mana_Threshold
				end,

				set = function(value)
					Druidcom.db.profile.Mana_Threshold = value
				end,

				validate= function(value)
					value = tonumber(value)
					if(value and value>0) then
						return TRUE
					else
						return FALSE
					end
				end
			},
--			refreshTime = {
--				type="range",
--				name=L["Refresh Time"],
--				desc=L["How many seconds between automatic updates? (0 for no automatic updates, applies only to leader or promoted)"],
--				min=0,
--				max=60,
--				step=5,
--				get = function()
--					return Druidcom.db.profile.refreshTime
--				end,
--
--				set = "SetRefreshTime",
--
--				validate= function(value)
--					value = tonumber(value)
--					if(value and value>0) then
--						return TRUE
--					else
--						return FALSE
--					end
--				end
--			}

		}
	}
Druidcom:RegisterChatCommand({"/druidcom", "/dc"}, OptionsTable)


----------------------  Ace Function Handlers  -----------------------------------------------

	function Druidcom:OnInitialize()
		local memoizations = {"Refresh"}
		for ability in pairs(Druidcom_Druid.ABILITIES) do
			table.insert(memoizations, ability)
		end
		Druidcom:RegisterMemoizations(memoizations)

		self:RegisterChatCommand({"/druidcom", "/dc"}, OptionsTable)
--		self:RegisterMetro("DC_UpdateTimer", self.RequestUpdate, 10, self)
		StaticPopupDialogs["DruidcomInnervateRequestPopup"] = {
					text = L["%s would like you to innervate %s"],
					button1 = TEXT(L["Do it!"]),
					button2 = TEXT(L["Not now!"]),
					OnAccept = function(data)
						local target, ability = unpack(data)
						local currentTarget = UnitName("target")
						TargetByName(target, true)
						CastSpell(SpellIndex[ability], BOOKTYPE_SPELL)
						if(currentTarget) then
							TargetByName(currentTarget, true)
						end
					end,
					OnCancel = function(data)
						local target, ability = unpack(data)
						Druidcom:SendMessage(false, ability)
					end,
					timeout = Druidcom_Druid.TARGETEXPIRETIME,
					whileDead = 0,
					hideOnEscape = 1}

		StaticPopupDialogs["DruidcomRebirthRequestPopup"] = {
					text = L["%s would like you to resurrect %s"],
					button1 = TEXT(L["Do it!"]),
					button2 = TEXT(L["Not now!"]),
					OnAccept = function(data)
						local target, ability = unpack(data)
						local currentTarget = UnitName("target")
						TargetByName(target, true)
						CastSpell(SpellIndex[ability], BOOKTYPE_SPELL)
						if(currentTarget) then
							TargetByName(currentTarget, true)
						end
					end,
					OnCancel = function(data)
						local target, ability = unpack(data)
						Druidcom:SendMessage(false, ability)
					end,
					timeout = Druidcom_Druid.TARGETEXPIRETIME,
					whileDead = 0,
					hideOnEscape = 1}
		titleFrame = getglobal("DruidcomTitleFrame")
		mainFrame = getglobal("DruidcomFrame")
	end

	function Druidcom:OnEnable()
		if(UnitName("player") == "Nimbal" or UnitName("player") == "Gorkul") then
			self:SetDebugging(true)
		end
		self:RegisterEvent("RosterLib_RosterChanged", 0.5)
		self:RegisterEvent("RosterLib_PendingRefresh")
		self:RegisterEvent("SPELLCAST_FAILED");
		self:RegisterEvent("SPELLCAST_STOP");
		self:RegisterEvent("SPELLCAST_INTERRUPTED");
		self:Hook("CastSpell")
		self:Hook("CastSpellByName")
		self:Hook("UseAction")
		self:Hook("SpellTargetUnit")
		self:Hook("TargetUnit")
		self:Hook("SpellStopTargeting")
		self:HookScript(WorldFrame, "OnMouseDown")

		self:RegisterComm(self.commPrefix, "RAID", "ReceiveMessage")
		self:RegisterComm(self.commPrefix, "WHISPER", "ReceiveMessage")

		self:RegisterDrops()
		self:FindSpells()
--		if(self:IsInCharge(UnitName("player"))) then
--			self:StartMetro("DC_UpdateTimer")
--		end
		roster = rosterlib.roster
		self:BuildInterface()
	end

	function Druidcom:OnDisable()
		self:DisableDisplay()
	end

----------------------  Hooks  and Events -----------------------------------------------

	function Druidcom:SPELLCAST_FAILED()
		if Druidcom_EndCast then
			Druidcom_EndCast = nil
			Druidcom_Target = nil
			Druidcom_Spell = nil
		end
	end

	function Druidcom:SPELLCAST_INTERRUPTED()
		if Druidcom_EndCast then
			Druidcom_EndCast = nil
			Druidcom_Target = nil
			Druidcom_Spell = nil
		end
	end

	function Druidcom:SPELLCAST_STOP()
		if Druidcom_EndCast then
			if(Druidcom_Endcast and L:HasReverseTranslation(Druidcom_Endcast)) then
				self:SendMessage(	Druidcom_Druid.ABILITIES[L(Druidcom_Endcast, "reverse")].cooldown,
									L(Druidcom_Endcast, "reverse"),
									false, 
									Druidcom_Target)
			end
			Druidcom_EndCast = nil
			Druidcom_Target = nil
			Druidcom_Spell = nil
		end
	end

	function Druidcom:OnMouseDown()
		self.hooks[WorldFrame].OnMouseDown.orig()
		if arg1 == "LeftButton" then
			local targetName;
			if Druidcom_Spell and UnitExists("mouseover") then
				targetName = UnitName("mouseover")
			end
			if Druidcom_Spell and targetName then
				Druidcom_EndCast = Druidcom_Spell
				Druidcom_Target = targetName
				Druidcom_Spell = nil
			end
		end
	end

	function Druidcom:SpellStopTargeting()
		self.hooks.SpellStopTargeting.orig()
		if Druidcom_Spell then
			Druidcom_Spell = nil
			Druidcom_EndCast = nil
			Druidcom_Target = nil
		end
	end

	function Druidcom:TargetUnit(unit)
		-- Call the original function
		self.hooks.TargetUnit.orig(unit)
		-- Look to see if we're currently waiting for a target internally
		-- If we are, then well glean the target info here.
		if Druidcom_Spell then
			-- Currently casting.. lets grab the target
			Druidcom_EndCast = Druidcom_Spell
			Druidcom_Target = UnitName(unit)
			-- Clear MyMod_Spell so we can wait for SPELLCAST_STOP
			Druidcom_Spell = nil
		end
	end

	function Druidcom:SpellTargetUnit(unit)
		-- Call the original function
		self.hooks.SpellTargetUnit.orig(unit)
		-- Look to see if we're currently waiting for a target internally
		-- If we are, then well glean the target info here.
		if Druidcom_Spell then
		-- Currently casting.. lets grab the target
			Druidcom_EndCast = Druidcom_Spell
			Druidcom_Target = UnitName(unit)
			-- Clear MyMod_Spell so we can wait for SPELLCAST_STOP
			Druidcom_Spell = nil
		end
	end

	function Druidcom:CastSpell(spellId, spellbookTabNum)
		-- Call the original function so there's no delay while we process
		self.hooks.CastSpell.orig(spellId, spellbookTabNum)
		-- Load the tooltip with the spell information
		Druidcom_Tooltip:SetSpell(spellId, spellbookTabNum)
		local spellName = Druidcom_TooltipTextLeft1:GetText()
		if SpellIsTargeting() then
			-- Spell is waiting for a target
			Druidcom_Spell = spellName
		else
			-- Spell is being cast on the current target.
			-- If ClearTarget() had been called, we'd be waiting target
			Druidcom_EndCast = spellName
			Druidcom_Target = UnitName("target")
		end
	end

	function Druidcom:CastSpellByName(spellName, onSelf)
		-- Call the original function
		self.hooks.CastSpellByName.orig(spellName, onSelf)
		-- This will give us the full spellname, including Rank.
		-- This can be filtered out quite easily
		local spellName = spellName
		if SpellIsTargeting() then
		-- Spell is waiting for a target
			Druidcom_Spell = spellName
		else
			-- Spell is being cast on the current target
			Druidcom_EndCast = spellName
			if onSelf then
				Druidcom_Target = UnitName("player")
			else
				Druidcom_Target = UnitName("target")
			end
		end
	end

	function Druidcom:UseAction(a1, a2, a3)
		-- Call the original function
		self.hooks.UseAction.orig(a1, a2, a3)
		-- Test to see if this is a macro
		if GetActionText(a1) then return end
		Druidcom_Tooltip:SetAction(a1)
		local spellName = Druidcom_TooltipTextLeft1:GetText()
		if SpellIsTargeting() then
			-- Spell is waiting for a target
			Druidcom_Spell = spellName
		else
			-- Spell is being cast on the current target
			Druidcom_EndCast = spellName
			Druidcom_Target = UnitName("target")
		end
	end

----------------------  Utility  -----------------------------------------------

	function Druidcom:RosterLib_RosterChanged(tbl)
		local RebuildNecessary = FALSE
		PeopleInCharge = {}
		for name, unit in pairs(tbl) do
			if( (unit.class and unit.class == "DRUID") or (unit.oldclass and unit.oldclass == "DRUID") ) then
				if(not unit.name) then
					druids[unit.oldname]= nil
					RebuildNecessary = true
				elseif(not unit.oldname) then
					druids[unit.name] = Druidcom_Druid:new(unit.name, unit.subgroup, unit.unitid)
					RebuildNecessary = true
				end
			end

			if(unit.rank and unit.rank > 0) then
				table.insert(PeopleInCharge, unit.name)
			end

-- 			if(unit.oldrank ~= unit.rank and unit.unitid == "player") then
-- 				if(unit.rank == 0) then
-- 					getglobal("DCRefreshButton"):Hide()
-- 				else
-- 					getglobal("DCRefreshButton"):Show()
-- 				end
-- 			end
		end

-- 		local player = roster:GetUnitObjectFromName(UnitName("player"))
-- 		if(player.rank ~= player.oldrank) then
-- 			RebuildNecessary = true
-- 		end

		if(GetNumRaidMembers() == 0) then
			druids = {}
			RebuildNecessary = true
		end
		
--		if(RebuildNecessary) then
			self:BuildInterface()
--		end
	end

	function Druidcom:IsInCharge(playername)
		for _, boss in PeopleInCharge do
			if(boss == playername) then
				return true
			end
		end
	end

	function Druidcom:FindSpells()
		local spellName
		local i= 1
		repeat
			spellName= GetSpellName(i, BOOKTYPE_SPELL)
			for ability in pairs(Druidcom_Druid.ABILITIES) do
				if(spellName == L[ability]) then
					SpellIndex[ability] = i
				end
			end
			i=i+1
		until not spellName
	end
	
	function Druidcom:RosterLib_PendingRefresh()
	end

----------------------  Interface  -----------------------------------------------
	function Druidcom:ToggleHidden(value)
		self.db.profile.hidden = value
		if(value) then
			self:DisableDisplay()
		else
			self:EnableDisplay()
		end
	end

	function Druidcom:SetRefreshTime(value)
		if(self.db.profile.refreshTime == 0 and value ~=0) then
--			self:ChangeMetroRate("DC_UpdateTimer", value)
-- 			if(self:IsInCharge(UnitName("player"))) then
-- 				self:StartMetro("DC_UpdateTimer")
-- 			end
-- 		elseif(self.db.profile.refreshTime ~= 0 and value ~=0) then
-- 			self:ChangeMetroRate("DC_UpdateTimer", value)
-- 		else
-- 			self:StopMetro("DC_UpdateTimer")
		end
		self.db.profile.refreshTime = value
	end

	function Druidcom:RegisterDrops()
		for i=1,10 do
			dewdrop:Register(	getglobal("Druidcom"..i.."InnervateButton"),
								'children', function(level, value) Druidcom:Dropdown(level, value, "Innervate") end
			)
			dewdrop:Register(	getglobal("Druidcom"..i.."RebirthButton"),
								'children', function(level, value) Druidcom:Dropdown(level, value, "Rebirth") end
			)
		end
		dewdrop:Register(	titleFrame,
							'children', function() dewdrop:FeedAceOptionsTable(OptionsTable) end)
	end


	function Druidcom:SaveWindowPos(name)
		self.db.profile.xPos = getglobal(name):GetLeft()
		self.db.profile.yPos = getglobal(name):GetTop()
	end


	function Druidcom:ToggleMinimize()
		if(self.db.profile.minimized) then
			self:Maximize()
--			self.db.profile.minimized=false
		else
			self:Minimize()
--			self.db.profile.minimized=true
		end
	end


	function Druidcom:BuildInterface()
		titleFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT",
		                                  self.db.profile.xPos,
		                                  self.db.profile.yPos)
		local i = 0
		if(self.db.profile.hidden) then
			self:DisableDisplay()
		elseif(GetNumRaidMembers() == 0 and not self:IsDebugging()) then
			self:Minimize()
			self:Print(L["Player not in raid, Druidcom minimized."])
		else
			self:EnableDisplay()

			if(self.db.profile.minimized) then
				self:Minimize()
			else
				self:Maximize()
			end

			for j=1,10 do
				getglobal("Druidcom"..j):Hide()
			end
			for name, druid in pairs(druids) do
				i=i+1
				getglobal("Druidcom"..i):Show()
				druid:SetFrameNumber(i)
			end
			if(i == 0) then
				self:Print(L["No Druids found in raid, Druidcom minimized."])
			end
		end
		if(i==0) then
			self:Minimize()
		else
			mainFrame:SetHeight(35*i+10)
		end
	end

	function Druidcom:DisableDisplay()
		titleFrame:Hide()
	end

	function Druidcom:EnableDisplay()
		titleFrame:Show()
	end

	function Druidcom:Minimize()
		mainFrame:Hide()
		getglobal("DCRefreshButton"):Hide()
		self.db.profile.minimized = true
	end

	function Druidcom:Maximize()
		local nDruids = 0
		for name, druid in pairs(druids) do
			nDruids = nDruids+1
		end
		if(nDruids > 0) then
			mainFrame:Show()
		else
			mainFrame:Hide()
		end
		self.db.profile.minimized = false
		getglobal("DCRefreshButton"):Show()
	end

	function Druidcom:Dropdown(level, value, ability)
		if(not dewdrop:GetOpenedParent()) then return end
		local recipient = string.sub(getglobal(dewdrop:GetOpenedParent():GetParent():GetName().."Name"):GetText(),3)
		if(	druids[recipient].Cooldowns[ability]
			and druids[recipient].Cooldowns[ability] > 0
			or not druids[recipient].Cooldowns[ability]
			or not self:IsInCharge(UnitName("player"))) then return end

		if(level == 1) then
			dewdrop:AddLine(	'text', L[ability],
								'isTitle', true)
			for class, on in pairs(self.db.profile.Classes[ability]) do
				if(on) then
					dewdrop:AddLine(	"text", L[class],
										"textR", COLOR[class].r,
										"textG", COLOR[class].g,
										"textB", COLOR[class].b,
										"hasArrow", true,
										"value", class)
				end
			end
		elseif(level == 2) then
			for name, unit in pairs(roster) do
				if (	unit.class == value 
						and self.db.profile.Classes["Innervate"][value] 
						and Druidcom_Druid.ABILITIES[ability].UnitIsSuitableTarget(unit)
					) then
					dewdrop:AddLine(	"text", unit.name,
										"textR", COLOR[value].r,
										"textG", COLOR[value].g,
										"textB", COLOR[value].b,
										"func", function(target, recipient, ability) Druidcom:SendRequest(target, recipient, ability) end,
										"arg1", unit.name,
										"arg2", recipient,
										"arg3", ability
					)
				end
			end
		end
	end

	function Druidcom:ShowNameLegend()
		local tooltip = getglobal("GameTooltip") --getglobal("Druidcom_NameLegend")
		tooltip:SetOwner(UIParent, "ANCHOR_NONE");
		tooltip:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -CONTAINER_OFFSET_X - 13, CONTAINER_OFFSET_Y);

		tooltip:SetText("Name:\n"..
						crayon:Colorize(COLOR["GREENHEX"], L["Green: "])..crayon:White(L["Everything OK"]).."\n"..
						crayon:Colorize(COLOR["REDHEX"], L["Red: "])..crayon:White(L["Dead"]).."\n"..
						crayon:Colorize(COLOR["YELLOWHEX"], L["Yellow: "])..crayon:White(L["Out of range"]).."\n"..
						crayon:Colorize(COLOR["BLUEHEX"], L["Blue: "])..crayon:White(L["No Druidcom detected"]).."\n"..
						crayon:Colorize(COLOR["GRAYHEX"], L["Gray: "])..crayon:White(L["Offline"]).."\n"..
						"\n"..
						L["Button-Flashing: "].."\n"..
						crayon:Colorize(COLOR["GREENHEX"], L["Green: "])..crayon:White(L["Assigned target innervated/rezzed"]).."\n"..
						crayon:Colorize(COLOR["YELLOWHEX"], L["Gray: "])..crayon:White(L["Other target innervated/rezzed"]).."\n"..
						crayon:Colorize(COLOR["REDHEX"], L["Red: "])..crayon:White(L["Request declined/ignored"]))
	end

-------------------------  Communications  ------------------------------------------------------
	
	function Druidcom:SendMessage(cooldown, ability, recipient, target)
		self:SendCommMessage("RAID", cooldown, ability, recipient, target)
		self:SendCommMessage("WHISPER", UnitName("player"), cooldown, ability, recipient, target)
	end

	function Druidcom:RequestUpdate()
		self:RosterLib_RosterChanged(roster)
--		if(self:IsInCharge(UnitName("player"))) then
			self:SendMessage(false , "Refresh")
--			if(self.db.profile.refreshTime > 0) then
--				self:StartMetro("DC_UpdateTimer")
--			end
--		end
	end


	function Druidcom:SendUpdate()
		for ability, spellindex in pairs(SpellIndex) do
			local cooldown
			local start, duration = GetSpellCooldown(spellindex, BOOKTYPE_SPELL)
			if(start ~=0) then
				cooldown = duration - ( GetTime() - start)
			else
				cooldown = 0
			end
			self:SendMessage(cooldown, ability)
		end
	end

	function Druidcom:ReceiveMessage(prefix, sender, distri, cooldown, ability, recipient, target)
		if(cooldown and  druids[sender]) then
			druids[sender]:UpdateCooldown(cooldown, ability)
		end

		if(ability and recipient and self:IsInCharge(sender) and target) then
			self:Debug(sender, target, ability)
			druids[recipient]:ActionReceived(ability, target, true)
			if(recipient == UnitName("player")) then
				self:PopupRequest(sender, target, ability)
			end
		elseif(ability and not recipient and not cooldown) then
			if(ability == "Refresh") then
				self:SendUpdate()
			else
				if(druids[sender]) then
					druids[sender]:ActionReceived(ability, target)
				end
			end
		end
	end

	function Druidcom:PopupRequest(sender, target, ability)
		local dialog = StaticPopup_Show("Druidcom"..ability.."RequestPopup", sender, target)
		if(dialog) then
			dialog.data= {target, ability}
		end
	end

	function Druidcom:SendRequest(target, recipient, ability)
		self:SendMessage(false, ability, recipient, target)
	end

	function Druidcom:DebugMe()
		if(self:IsDebugging()) then
--  			druids["Gorkul"] = Druidcom_Druid:new("Gorkul", 1, "player")
--  			self:BuildInterface()
--  			druids["Gorkul"]:ButtonFlash("Innervate", "RED")
--  			druids["Gorkul"]:ButtonFlash("Rebirth", "GREEN")
--  			druids["Gorkul"]:UpdateCooldown(70, "Innervate")
--  			druids["Gorkul"]:UpdateCooldown(130, "Rebirth")
			for ability in Druidcom_Druid.ABILITIES do
				self:Debug(ability.." Index: ", SpellIndex[ability], ".")
			end
		end

	end
